<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
        <div class="card">
            <div class="payment-top-tab mt-3 mb-3">
            <ul class="nav nav-tabs card-header-tabs align-items-end">
               <li class="nav-item">
                    <a class="nav-link stripe_active_label" href="<?php echo url('settings/payment/stripe'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_stripe')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link cod_active_label" href="<?php echo url('settings/payment/cod'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_cod_short')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active apple_pay_active_label" href="<?php echo url('settings/payment/applepay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_apple_pay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                  <li class="nav-item">
                    <a class="nav-link razorpay_active_label" href="<?php echo url('settings/payment/razorpay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_razorpay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link paypal_active_label" href="<?php echo url('settings/payment/paypal'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_paypal')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                   <li class="nav-item">
                    <a class="nav-link paytm_active_label" href="<?php echo url('settings/payment/paytm'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_paytm')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link wallet_active_label" href="<?php echo url('settings/payment/wallet'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_wallet')); ?><span class="badge ml-2"></span>
                    </a>
                </li>

            </ul>
        </div>
            <div class="card-body">
      	        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
                <div class="row restaurant_payout_create">
                    <div class="restaurant_payout_create-inner">
                        <fieldset>
                            <legend><?php echo e(trans('lang.app_setting_apple_pay')); ?></legend>
                            <div class="form-check width-100">
                                <input type="checkbox" class="enable_apple_pay" id="enable_apple_pay">
                                <label class="col-3 control-label" for="enable_apple_pay"><?php echo e(trans('lang.app_setting_enable_apple_pay')); ?></label>
                                <div class="form-text text-muted">
                                    <?php echo trans('lang.app_settings_enable_apple_pay_help'); ?>

                                </div>
                            </div>  

                            <div class="form-group row width-100">
                                <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_stripe_secret')); ?></label>
                                <div class="col-7">
                                    <input type="text" class="form-control stripe_secret">
                                    <div class="form-text text-muted">
                                        <?php echo trans('lang.app_setting_stripe_secret_help'); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="form-group row width-100">
                                <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_apple_pay_merchant_id')); ?></label>
                                <div class="col-7">
                                    <input type="text" class="form-control apple_pay_merchant_id">
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
            <div class="form-group col-12 text-center btm-btn">
                <button type="button" class="btn btn-primary save_apple_pay_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
            </div>
            </div>
        </div>   

 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
        var database = firebase.firestore();
        var stripeData = database.collection('settings').doc('stripeSettings');
        var codData = database.collection('settings').doc('CODSettings');
        var ref = database.collection('settings').doc('applePay');
        var razorpayData = database.collection('settings').doc('razorpaySettings');
        var paypalData = database.collection('settings').doc('paypalSettings');
        var paytmData = database.collection('settings').doc('PaytmSettings');
        var walletData = database.collection('settings').doc('walletSettings');


        $(document).ready(function(){
            jQuery("#data-table_processing").show();
            ref.get().then( async function(snapshots){
            var applePay = snapshots.data();


            if(applePay.isEnabled){
                $(".enable_apple_pay").prop('checked',true);
                jQuery(".apple_pay_active_label span").addClass('badge-success');
                jQuery(".apple_pay_active_label span").text('Active');
            }
            $(".apple_pay_merchant_id").val(applePay.merchantId); 
            
            codData.get().then(  async function(codSnapshots){
                var cod = codSnapshots.data();
                if(cod.isEnabled){
                    jQuery(".cod_active_label span").addClass('badge-success');
                    jQuery(".cod_active_label span").text('Active');
                }
            })

            stripeData.get().then(  async function(stripeSnapshots){
                var stripe = stripeSnapshots.data();
                if(stripe.isEnabled){
                    jQuery(".stripe_active_label span").addClass('badge-success');
                    jQuery(".stripe_active_label span").text('Active');
                }
            })


            razorpayData.get().then(  async function(razorpaySnapshots){
                var razorPay = razorpaySnapshots.data();
                if(razorPay.isEnabled){
                    jQuery(".razorpay_active_label span").addClass('badge-success');
                    jQuery(".razorpay_active_label span").text('Active');
                }
            })

             paypalData.get().then(  async function(paypalSnapshots){
                var paypal = paypalSnapshots.data();
                if(paypal.isEnabled){
                    jQuery(".paypal_active_label span").addClass('badge-success');
                    jQuery(".paypal_active_label span").text('Active');
                }
            })

        paytmData.get().then(  async function(codSnapshots){
            var paytm= codSnapshots.data();
            if(paytm.isEnabled){
                jQuery(".paytm_active_label span").addClass('badge-success');
                jQuery(".paytm_active_label span").text('Active');
            }
        })

        walletData.get().then(  async function(walletSnapshots){
            var wallet = walletSnapshots.data();
                if(wallet.isEnabled){
                    jQuery(".wallet_active_label span").addClass('badge-success');
                    jQuery(".wallet_active_label span").text('Active');
                }
        })

      
            jQuery("#data-table_processing").hide();
            /* console.log($(".note-editable").html()); */  
        })

  $(".save_apple_pay_btn").click(function(){
     
        var isApplePayEnabled = $(".enable_apple_pay").is(":checked");
        var merchantId = $(".apple_pay_merchant_id").val();
        database.collection('settings').doc("applePay").update({'isEnabled':isApplePayEnabled,'merchantId':merchantId}).then(function(result) {
                window.location.href = '<?php echo e(url("settings/payment/applepay")); ?>';
                 });
            })

})

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/gromartadmin.siswebapp.com/resources/views/settings/app/applepay.blade.php ENDPATH**/ ?>