<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
        <div class="card">
            <ul class="nav nav-tabs ">
               <li class="nav-item">
                    <a class="nav-link stripe_active_label" href="<?php echo url('settings/payment/stripe'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_stripe')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link cod_active_label" href="<?php echo url('settings/payment/cod'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_cod_short')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active apple_pay_active_label" href="<?php echo url('settings/payment/applepay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_apple_pay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                  <li class="nav-item">
                    <a class="nav-link razorpay_active_label" href="<?php echo url('settings/payment/razorpay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_razorpay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>

            </ul>
            <div class="card-body">
      	        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>

                <div class="form-check">
                    <input type="checkbox" class=" ml-2 form-check-inline enable_apple_pay" id="enable_apple_pay">
                    <label class="col-3 control-label" for="enable_apple_pay"><?php echo e(trans('lang.app_setting_enable_apple_pay')); ?></label>
                    <span class="ml-2"><?php echo trans('lang.app_settings_enable_apple_pay_help'); ?></span>
                </div>  
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_apple_pay_merchant_id')); ?></label>
                    <input type="text" class=" col-7 form-control apple_pay_merchant_id">
                </div>

                <div class="form-group col-12 text-right">
                    <button type="button" class="btn btn-primary save_apple_pay_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                </div>
            </div>
        </div>   
    </div>
 


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

 <script>
        var database = firebase.firestore();
        var stripeData = database.collection('settings').doc('stripeSettings');
        var codData = database.collection('settings').doc('CODSettings');
        var ref = database.collection('settings').doc('applePay');
        var razorpayData = database.collection('settings').doc('razorpaySettings');

        $(document).ready(function(){
            jQuery("#data-table_processing").show();
            ref.get().then( async function(snapshots){
            var applePay = snapshots.data();


            if(applePay.isEnabled){
                $(".enable_apple_pay").prop('checked',true);
                jQuery(".apple_pay_active_label span").addClass('badge-success');
                jQuery(".apple_pay_active_label span").text('Active');
            }
            $(".apple_pay_merchant_id").val(applePay.merchantId); 
            
            codData.get().then(  async function(codSnapshots){
                var cod = codSnapshots.data();
                if(cod.isEnabled){
                    jQuery(".cod_active_label span").addClass('badge-success');
                    jQuery(".cod_active_label span").text('Active');
                }
            })

            stripeData.get().then(  async function(stripeSnapshots){
                var stripe = stripeSnapshots.data();
                if(stripe.isEnabled){
                    jQuery(".stripe_active_label span").addClass('badge-success');
                    jQuery(".stripe_active_label span").text('Active');
                }
            })


            razorpayData.get().then(  async function(razorpaySnapshots){
                var razorPay = razorpaySnapshots.data();
                if(razorPay.isEnabled){
                    jQuery(".razorpay_active_label span").addClass('badge-success');
                    jQuery(".razorpay_active_label span").text('Active');
                }
            })

      
            jQuery("#data-table_processing").hide();
            /* console.log($(".note-editable").html()); */  
        })

  $(".save_apple_pay_btn").click(function(){
     
        var isApplePayEnabled = $(".enable_apple_pay").is(":checked");
        var merchantId = $(".apple_pay_merchant_id").val();
        database.collection('settings').doc("applePay").update({'isEnabled':isApplePayEnabled,'merchantId':merchantId}).then(function(result) {
                window.location.href = '<?php echo e(url("settings/payment/applepay")); ?>';
                 });
            })

})

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/settings/app/applepay.blade.php ENDPATH**/ ?>