<?php $__env->startSection('content'); ?>
  <div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.vendor_plural')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href= "<?php echo route('vendors'); ?>" ><?php echo e(trans('lang.vendor_plural')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.create_vendor')); ?></li>
            </ol>
        </div>
    <div>

    <div class="card-body">
        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
        <div class="error_top"></div>
        <div class="row vendor_payout_create">
        <div class="vendor_payout_create-inner">
          <fieldset>
            <legend><?php echo e(trans('lang.admin_area')); ?></legend>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.first_name')); ?></label>
              <div class="col-7">
                <input type="text" class="form-control user_first_name" required>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.user_first_name_help")); ?>

                </div>
              </div>
            </div>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.last_name')); ?></label>
              <div class="col-7">
                <input type="text" class="form-control user_last_name">
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.user_last_name_help")); ?>

                </div>
              </div>
            </div>
            
            
            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.email')); ?></label>
              <div class="col-7">
                <input type="email" class="form-control user_email" required>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.user_email_help")); ?>

                </div>
              </div>
            </div>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.password')); ?></label>
              <div class="col-7">
                <input type="password" class="form-control user_password" required>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.user_password_help")); ?>

                </div>
              </div>
            </div>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.user_phone')); ?></label>
              <div class="col-7">
                <input type="text" class="form-control user_phone" >
                <div class="form-text text-muted w-50">
                  <?php echo e(trans("lang.user_phone_help")); ?>

                </div>
              </div>  
            </div>

            <div class="form-group row width-100">
              <label class="col-3 control-label"><?php echo e(trans('lang.vendor_image')); ?></label>
              <input type="file" onChange="handleFileSelectowner(event)" class="col-7">
              <div id="uploding_image_owner"></div>
              <div class="uploaded_image_owner" style="display:none;"><img id="uploaded_image_owner" src="" width="150px" height="150px;"></div>
            </div>        
    
        </fieldset>   
        
        <fieldset>
          <legend><?php echo e(trans('lang.vendor_details')); ?></legend>
              
              <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vendor_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control vendor_name" required>
                    <div class="form-text text-muted">
                        <?php echo e(trans("lang.vendor_name_help")); ?>

                    </div>
                  </div>
              </div>

              <div class="form-group row width-50">
               <label class="col-3 control-label"><?php echo e(trans('lang.category')); ?></label>
               <div class="col-7">
                <select id='vendor_cuisines' class="form-control" required>
                  <option value=""><?php echo e(trans("lang.select_cuisines")); ?></option>
                </select>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.vendor_cuisines_help")); ?>

                </div>
               </div>
              </div>

              <div class="form-group row width-50">
               <label class="col-3 control-label"><?php echo e(trans('lang.vendor_phone')); ?></label>
               <div class="col-7">
                  <input type="text" class="form-control vendor_phone" required>
                  <div class="form-text text-muted">
                    <?php echo e(trans("lang.vendor_phone_help")); ?>

                  </div>
                </div>
               </div>

              <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.vendor_address')); ?></label>
              <div class="col-7">
                <input type="text" class="form-control vendor_address" required>
                <div class="form-text text-muted">
                        <?php echo e(trans("lang.vendor_address_help")); ?>

                </div>
              </div>
            </div>
      
            <div class="form-group row width-100">
              <div class="col-12">
                <h6>*  Don't Know your cordinates ? use <a target="_blank" href="https://www.latlong.net/">Latitude and Longitude Finder</a></h6>
              </div>
            </div>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.vendor_latitude')); ?></label>
              <div class="col-7">
                <input class="form-control vendor_latitude" type="number" min="-90" max="90">
                <div class="form-text text-muted">
                        <?php echo e(trans("lang.vendor_latitude_help")); ?>

                </div>
              </div>
            </div>

            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.vendor_longitude')); ?></label>
              <div class="col-7">
                <input class="form-control vendor_longitude" type="number" min="-180" max="180">
                <div class="form-text text-muted">
                        <?php echo e(trans("lang.vendor_longitude_help")); ?>

                </div>
              </div>
            </div>
          
            <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.vendor_image')); ?></label>
              <div class="col-7">
                <input type="file" onChange="handleFileSelect(event,'photo')">
                <div id="uploding_image_vendor"></div>
                <div class="uploaded_image" style="display:none;"><img id="uploaded_image" src="" width="150px" height="150px;"></div>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.vendor_image_help")); ?>

                </div>
              </div>
            </div>

          <div class="form-group row width-100">
            <label class="col-3 control-label "><?php echo e(trans('lang.vendor_description')); ?></label>
              <div class="col-7">
                <textarea rows="7" class="vendor_description form-control" id="vendor_description"></textarea>
              </div>
          </div>
          </fieldset>

              <fieldset>
             <legend><?php echo e(trans('lang.gallery')); ?></legend>

          <div class="form-group row width-50 vendor_image">
            <div class="">
                <div id="photos"></div>
            </div>
          </div>

          <div class="form-group row">
            <div>
                <input type="file" onChange="handleFileSelect(event,'photos')">
                <div id="uploding_image_photos"></div>
            </div>
          </div>
      </fieldset>

          <fieldset>
        <legend><?php echo e(trans('lang.services')); ?></legend>

        <div class="form-group row">
          
          <div class="form-check width-100">
            <input type="checkbox" id="Free_Wi_Fi">
            <label class="col-3 control-label" for="Free_Wi_Fi">Free Wi-Fi</label>
          </div>
          <div class="form-check width-100">
            <input type="checkbox" id="Good_for_Breakfast">
            <label class="col-3 control-label" for="Good_for_Breakfast">Good for Breakfast</label>
          </div>
          <div class="form-check width-100">
            <input type="checkbox" id="Good_for_Dinner">
            <label class="col-3 control-label" for="Good_for_Dinner">Good for Dinner</label>
          </div>
          <div class="form-check width-100">
            <input type="checkbox" id="Good_for_Lunch">
            <label class="col-3 control-label" for="Good_for_Lunch">Good for Lunch</label>
          </div>

          <div class="form-check width-100">
            <input type="checkbox" id="Live_Music">
            <label class="col-3 control-label" for="Live_Music">Live Music</label>
          </div>

          <div class="form-check width-100">
            <input type="checkbox" id="Outdoor_Seating">
            <label class="col-3 control-label" for="Outdoor_Seating">Outdoor Seating</label>
          </div>

          <div class="form-check width-100">
            <input type="checkbox" id="Takes_Reservations">
            <label class="col-3 control-label" for="Takes_Reservations">Takes Reservations</label>
          </div>

          <div class="form-check width-100">
            <input type="checkbox" id="Vegetarian_Friendly">
            <label class="col-3 control-label" for="Vegetarian_Friendly">Vegetarian Friendly</label>
          </div>

        </div>
      </fieldset>

      <fieldset>
        <legend><?php echo e(trans('lang.timing')); ?></legend>

        <div class="form-group row">
          
          <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.Opening_Time')); ?></label>
              <div class="col-7">
                <input type="time" class="form-control" id="opentime" required>
              </div>
          </div>

          <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.Closing_Time')); ?></label>
              <div class="col-7">
                <input type="time" class="form-control" id="closetime" required>
              </div>
          </div>

        </div>
      </fieldset>

      <fieldset>
        <legend><?php echo e(trans('lang.vendor_status')); ?></legend>

        <div class="form-group row">
          
          <div class="form-group row width-50">
              <div class="form-check width-100">
                <input type="checkbox" id="is_open">
                <label class="col-3 control-label" for="is_open"><?php echo e(trans('lang.Is_Open')); ?></label>
              </div>
          </div>

        </div>
      </fieldset>

          <!-- <fieldset>
            <legend><?php echo e(trans('lang.admin_area')); ?></legend>
            <div class="form-group row width-50">
               <label class="col-3 control-label"><?php echo e(trans('lang.vendor_cuisines')); ?></label>
               <div class="col-7">
                <select id='vendor_owners' class="form-control">
                  <option value=""><?php echo e(trans('lang.select_owner')); ?></option>
                </select>
               </div>
            </div>
           </fieldset> -->

       </div>
  </div>
</div>

      <div class="form-group col-12 text-center">
          <button type="button" class="btn btn-primary  create_vendor_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
         <a href="<?php echo route('vendors'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
      </div>

    </div>
  </div>
</div>


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/crypto-js.js"></script>
 <script>
  var database = firebase.firestore();
  var photo ="";
  var vendorPhoto = '';
  var vendorOwnerId = "";
  var vendorOwnerOnline = false;
  var photocount=0;
  var restaurnt_photos = [];
  var ownerphoto = '';
  //var createdAt= firebase.firestore.FieldValue.serverTimestamp();
console.log('createdAt'+JSON.stringify(createdAt));
  $(document).ready(function(){
      jQuery("#data-table_processing").show();

     database.collection('vendor_categories').get().then( async function(snapshots){
          snapshots.docs.forEach((listval) => {
                var data = listval.data();
                    $('#vendor_cuisines').append($("<option></option>")
                        .attr("value", data.id)
                        .text(data.title));
              })
      });
 
      
        jQuery("#data-table_processing").hide();
      })


  
     $(".create_vendor_btn").click(function(){
      $(".error_top").hide();
      // function createVendor(){
      var vendorname = $(".vendor_name").val();
      var cuisines = $("#vendor_cuisines option:selected").val();
      var vendorOwner = $("#vendor_owners option:selected").val();
      var address = $(".vendor_address").val(); 
      var latitude = parseFloat($(".vendor_latitude").val());
      var longitude = parseFloat($(".vendor_longitude").val());
      var description = $(".vendor_description").val();
      var phonenumber = $(".vendor_phone").val();
      var categoryTitle = $( "#vendor_cuisines option:selected" ).text();

      var userFirstName = $(".user_first_name").val();
      var userLastName = $(".user_last_name").val();
      var email = $(".user_email").val();
      var password = $(".user_password").val();
      var userPhone = $(".user_phone").val();

      var reststatus =false;
      if($("#is_open").is(':checked')){
          reststatus =true;
      }

      var opentime = $("#opentime").val();
      var opentime_val = $("#opentime").val();
      if(opentime){
         opentime=new Date('1970-01-01T' + opentime + 'Z')
            .toLocaleTimeString('en-US',
              {timeZone:'UTC',hour12:true,hour:'numeric',minute:'numeric'}
            );
      }

      var closetime = $("#closetime").val();
      var closetime_val = $("#closetime").val();
    
      if(closetime){
         closetime=new Date('1970-01-01T' + closetime + 'Z')
            .toLocaleTimeString('en-US',
              {timeZone:'UTC',hour12:true,hour:'numeric',minute:'numeric'}
            );
      }      
      // console.log('closetime '+closetime);
      // console.log('opentime '+opentime);
      var user_name = userFirstName+" "+userLastName;
      var user_id = "<?php echo uniqid(); ?>";
      var vendor_id = database.collection("tmp").doc().id;
      var name = userFirstName+" "+userLastName;


              var Free_Wi_Fi="No";
              if($("#Free_Wi_Fi").is(":checked")){
                  Free_Wi_Fi="Yes";
              }
              var Good_for_Breakfast="No";
              if($("#Good_for_Breakfast").is(':checked')){
                  Good_for_Breakfast="Yes";
              }
              var Good_for_Dinner="No";
              if($("#Good_for_Dinner").is(':checked')){
                  Good_for_Dinner="Yes";
              }
              var Good_for_Lunch="No";
              if($("#Good_for_Lunch").is(':checked')){
                  Good_for_Lunch="Yes";
              }
              var Live_Music="No";
              if($("#Live_Music").is(':checked')){
                  Live_Music="Yes";
              }
              var Outdoor_Seating="No";
              if($("#Outdoor_Seating").is(':checked')){
                  Outdoor_Seating="Yes";
              }
              var Takes_Reservations="No";
              if($("#Takes_Reservations").is(':checked')){
                  Takes_Reservations="Yes";
              }
              var Vegetarian_Friendly="No";
              if($("#Vegetarian_Friendly").is(':checked')){
                  Vegetarian_Friendly="Yes";
              }

              var filters_new={"Free Wi-Fi":Free_Wi_Fi,"Good for Breakfast":Good_for_Breakfast,"Good for Dinner":Good_for_Dinner,"Good for Lunch":Good_for_Lunch,"Live Music":Live_Music,"Outdoor Seating":Outdoor_Seating,"Takes Reservations":Takes_Reservations,"Vegetarian Friendly":Vegetarian_Friendly};
              console.log(filters_new);

      if(userFirstName == ''){

          $(".error_top").show();
          $(".error_top").html("");
          $(".error_top").append("<p><?php echo e(trans('lang.enter_owners_name_error')); ?></p>");
          window.scrollTo(0, 0);
      }else if(email == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.enter_owners_email')); ?></p>");
              window.scrollTo(0, 0);
      } 
      else if(password == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.enter_owners_password_error')); ?></p>");
              window.scrollTo(0, 0);
      } else if(userPhone == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.enter_owners_phone')); ?></p>");
              window.scrollTo(0, 0);
      }  else if(vendorname == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_name_error')); ?></p>");
              window.scrollTo(0, 0);
      } else if(cuisines == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_cuisine_error')); ?></p>");
              window.scrollTo(0, 0);
      }  else if(phonenumber == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_phone_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(address == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_address_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(isNaN(latitude)){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_lattitude_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(latitude < -90 || latitude > 90){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_lattitude_limit_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(isNaN(longitude)){
          $(".error_top").show();
          $(".error_top").html("");
          $(".error_top").append("<p><?php echo e(trans('lang.vendor_longitude_error')); ?></p>");
          window.scrollTo(0, 0);
      
      }else if(longitude < -180 || longitude > 180){
          $(".error_top").show();
          $(".error_top").html("");
          $(".error_top").append("<p><?php echo e(trans('lang.vendor_longitude_limit_error')); ?></p>");
          window.scrollTo(0, 0);
      
      }else if(description == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_description_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(opentime == ''){
          $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_opentime_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(closetime == ''){
              $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_closetime_error')); ?></p>");
              window.scrollTo(0, 0);
      }else if(opentime_val > closetime_val ){
              $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p><?php echo e(trans('lang.vendor_opentime_closetime_error')); ?></p>");
              window.scrollTo(0, 0);
      }else{

      

      firebase.auth().createUserWithEmailAndPassword(email, password)
            .then(function (firebaseUser) {
            console.log(firebaseUser);
            console.log("firebaseUser");
            user_id=firebaseUser.user.uid;
            database.collection('users').doc(user_id).set({'firstName':userFirstName,'lastName':userLastName,'email':email,'phoneNumber':userPhone,'profilePictureURL':ownerphoto,'role':'vendor','id':user_id,'vendorID':vendor_id,createdAt:createdAt}).then(function(result) {

              coordinates=new firebase.firestore.GeoPoint(latitude,longitude);
              

               geoFirestore.collection('vendors').doc(vendor_id).set({'title':vendorname,'description':description,'latitude':latitude,'longitude':longitude,'location':address,'photo':vendorPhoto,'categoryID':cuisines,'phonenumber':phonenumber,'categoryTitle':categoryTitle,'coordinates':coordinates,'id':vendor_id,'filters':filters_new,'photos':restaurnt_photos,'author':user_id,'authorName':name,'authorProfilePic':ownerphoto,'reststatus':reststatus,'closetime':closetime,'closetime':closetime,'opentime':opentime,hidephotos:false,createdAt:createdAt}).then(function(result) {
                
                    window.location.href = '<?php echo e(route("vendors")); ?>';
                
                }); 

            })

            }) .catch(function (error) {
              
              $(".error_top").show();
              $(".error_top").html("");
              $(".error_top").append("<p>"+error+"</p>");
            });
          }

    })


  $(document).on("click",".remove-btn",function() {
        var id=$(this).attr('data-id');
        var photo_remove=$(this).attr('data-img');
        $("#photo_"+id).remove();
        index = restaurnt_photos.indexOf(photo_remove);
        if (index > -1) {
          restaurnt_photos.splice(index, 1); // 2nd parameter means remove one item only
        }

  });

  function removeImage(photo_remove,photocount) {
      
      $("#photo_"+photocount).remove();
      index = restaurnt_photos.indexOf(photo_remove);
      if (index > -1) {
        restaurnt_photos.splice(index, 1); // 2nd parameter means remove one item only
      }
      
      //restaurnt_photos
  }

  var storageRef = firebase.storage().ref('images');

  function handleFileSelectowner(evt) {
      var f = evt.target.files[0];
      var reader = new FileReader();
      reader.onload = (function(theFile) {
        return function(e) {
            
          var filePayload = e.target.result;
          var hash = CryptoJS.SHA256(Math.random() + CryptoJS.SHA256(filePayload));
            var val =f.name;       
          var ext=val.split('.')[1];
          var docName=val.split('fakepath')[1];
          var filename = (f.name).replace(/C:\\fakepath\\/i, '')

          var timestamp = Number(new Date());      
          var uploadTask = storageRef.child(filename).put(theFile);
          console.log(uploadTask);
          uploadTask.on('state_changed', function(snapshot){

          var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
          console.log('Upload is ' + progress + '% done');
          jQuery("#uploding_image_owner").text("Image is uploading...");
        }, function(error) {
        }, function() {
            uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
                jQuery("#uploding_image_owner").text("Upload is completed");
                ownerphoto = downloadURL;
                
                $("#uploaded_image_owner").attr('src',ownerphoto);
                $(".uploaded_image_owner").show();

          });   
        });
      
      };
    })(f);
  reader.readAsDataURL(f);
} 

  function handleFileSelect(evt,type) {
      var f = evt.target.files[0];
      var reader = new FileReader();
      reader.onload = (function(theFile) {
        return function(e) {
            
          var filePayload = e.target.result;
          var hash = CryptoJS.SHA256(Math.random() + CryptoJS.SHA256(filePayload));
            var val =f.name;       
          var ext=val.split('.')[1];
          var docName=val.split('fakepath')[1];
          var filename = (f.name).replace(/C:\\fakepath\\/i, '')

          var timestamp = Number(new Date());      
          var uploadTask = storageRef.child(filename).put(theFile);
          console.log(uploadTask);
          uploadTask.on('state_changed', function(snapshot){

          var progress = (snapshot.bytesTransferred / snapshot.totalBytes) * 100;
          console.log('Upload is ' + progress + '% done');
          if(type=="photo"){
            jQuery("#uploding_image_vendor").text("Image is uploading...");  
          }else{
            jQuery("#uploding_image_photos").text("Image is uploading...");
          }
          
        }, function(error) {
        }, function() {
            uploadTask.snapshot.ref.getDownloadURL().then(function(downloadURL) {
                
                if(type=="photo"){
                  jQuery("#uploding_image_vendor").text("Upload is completed");
                }else{
                  jQuery("#uploding_image_photos").text("Upload is completed");
                }

                photo = downloadURL;
                  if(type=="photo"){
                  vendorPhoto = downloadURL;
                }
                
                  if(photo){
                    if(type=='photo'){
                        $("#uploaded_image").attr('src',photo);
                        $(".uploaded_image").show();
                    }else if(type=='photos'){

                        photocount++;
                        photos_html='<span class="image-item" id="photo_'+photocount+'"><span class="remove-btn" data-id="'+photocount+'" data-img="'+photo+'"><i class="fa fa-remove"></i></span><img width="100px" id="" height="auto" src="'+photo+'"></span>';
                        $("#photos").append(photos_html);
                        restaurnt_photos.push(photo);
                    }
                  }
                

          });   
        });
      
      };
    })(f);
  reader.readAsDataURL(f);
}   


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/gromartadmin.siswebapp.com/resources/views/vendors/create.blade.php ENDPATH**/ ?>