<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.homepageTemplate')); ?></h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.homepageTemplate')); ?></li>
            </ol>
        </div>
        <div>


        </div>

    </div>

    <div class="card-body">

        <div id="data-table_processing" class="dataTables_processing panel panel-default"
             style="display: none;"><?php echo e(trans('lang.processing')); ?>

        </div>
        <div class="error_top"></div>

        <div class="row vendor_payout_create">
            <div class="vendor_payout_create-inner">
                <fieldset>
                    <legend><?php echo e(trans('lang.homepageTemplate')); ?></legend>

                    <div class="form-group width-100">
                        <textarea class="form-control col-7" name="cabLandingPage" id="cabLandingPage"></textarea>
                    </div>


                </fieldset>

            </div>
        </div>
    </div>

    <div class="form-group col-12 text-center btm-btn">
        <button type="button" class="btn btn-primary  create_btn"><i
                    class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?>

        </button>
        <a href="<?php echo route('cabLandingPage'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?>

        </a>
    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>

    var database = firebase.firestore();
    var photo = "";
    var ref = database.collection('settings').doc('cabLandingPageTemplate');
    $(document).ready(function () {
        try {
            jQuery("#data-table_processing").show();
            ref.get().then(async function (snapshots) {
                var cabLandingPageTemplateData = snapshots.data();

                if (cabLandingPageTemplateData == undefined) {
                    database.collection('settings').doc('cabLandingPageTemplate').set({"cabLandingPage": ""});
                }

                if (cabLandingPageTemplateData.cabLandingPage != undefined) {
                    $('#cabLandingPage').summernote("code", cabLandingPageTemplateData.cabLandingPage);
                }
            });
        } catch (error) {

        }

        jQuery("#data-table_processing").hide();

        $('#cabLandingPage').summernote({
            height: 400,
            width: 1024,
            toolbar: [
                // [groupName, [list of button]]
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['forecolor', ['forecolor']],
                ['backcolor', ['backcolor']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                ['view', ['fullscreen', 'codeview', 'help']],
            ]
        });
        $(".create_btn").click(function () {

            var cabLandingPage = $('#cabLandingPage').summernote('code');

            if (cabLandingPage == '') {
                $(".error_top").show();
                $(".error_top").html("");
                $(".error_top").append("<p><?php echo e(trans('lang.cablanding_template_error')); ?></p>");
                window.scrollTo(0, 0);

            } else {

                database.collection('settings').doc('cabLandingPageTemplate').update({'cabLandingPage': cabLandingPage}).then(function (result) {
                    window.location.href = '<?php echo e(route("cabLandingPage")); ?>';
                })

            }
        })
    });


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/cab_landing_page/index.blade.php ENDPATH**/ ?>