<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
        <div class="card">
            <ul class="nav nav-tabs">
            <li class="nav-item">
                    <a class="nav-link stripe_active_label" href="<?php echo url('settings/payment/stripe'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_stripe')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link cod_active_label" href="<?php echo url('settings/payment/cod'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_cod_short')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link apple_pay_active_label" href="<?php echo url('settings/payment/applepay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_apple_pay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
                  <li class="nav-item">
                    <a class="nav-link active razorpay_active_label" href="<?php echo url('settings/payment/razorpay'); ?>"><i class="fa fa-envelope-o mr-2"></i><?php echo e(trans('lang.app_setting_razorpay')); ?><span class="badge ml-2"></span>
                    </a>
                </li>
            </ul>

            <div class="card-body">
      	        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
                  
                <div class="form-check">
                    <input type="checkbox" class="form-check-input enable_razorpay" id="enable_razorpay">
                    <label class="col-3 control-label" for="enable_razorpay"><?php echo e(trans('lang.app_setting_enable_razorpay')); ?></label>
                    <span class="ml-2"><?php echo trans('lang.app_setting_enable_razorpay_help'); ?></span>
                </div>  
                <div class="form-check">
                    <input type="checkbox" class=" ml-2 form-check-inline sand_box_mode" id="sand_box_mode">
                    <label class="col-3 control-label" for="sand_box_mode"><?php echo e(trans('lang.app_setting_enable_sandbox_mode_razorpay')); ?></label>
                </div> 
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_razorpay_key')); ?></label>
                    <input type="text" class=" col-7 form-control razorpay_key">
                    <div class="form-text text-muted">
                        <?php echo trans('lang.app_setting_razorpay_key_help'); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.app_setting_razorpay_secret')); ?></label>
                    <input type="text" class=" col-7 form-control razorpay_secret">
                    <div class="form-text text-muted">
                        <?php echo trans('lang.app_setting_razorpay_secret_help'); ?>

                    </div>
                </div>

                <div class="form-group col-12 text-right">
                    <button type="button" class="btn btn-primary save_razorpay_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                </div>
            </div>
        </div>   
    </div> 


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

  <script>

        var database = firebase.firestore();
        var ref = database.collection('settings').doc('razorpaySettings');
        var stripeData = database.collection('settings').doc('stripeSettings');
        var codData = database.collection('settings').doc('CODSettings');
        var applePayData = database.collection('settings').doc('applePay');


        $(document).ready(function(){
         jQuery("#data-table_processing").show();
         ref.get().then( async function(snapshots){
            var razorpay = snapshots.data();

        if(razorpay.isEnabled){
            $(".enable_razorpay").prop('checked',true);
            jQuery(".razorpay_active_label span").addClass('badge-success');
            jQuery(".razorpay_active_label span").text('Active');
        }

        if(razorpay.isSandboxEnabled){
            $(".sand_box_mode").prop('checked',true);
        }

        $(".razorpay_key").val(razorpay.razorpayKey);
        $(".razorpay_secret").val(razorpay.razorpaySecret);

        codData.get().then(  async function(codSnapshots){
            var cod = codSnapshots.data();
            if(cod.isEnabled){
                jQuery(".cod_active_label span").addClass('badge-success');
                jQuery(".cod_active_label span").text('Active');
            }

        })

        applePayData.get().then(  async function(applePaySnapshots){
            var applePay = applePaySnapshots.data();
            if(applePay.isEnabled){
                jQuery(".apple_pay_active_label span").addClass('badge-success');
                jQuery(".apple_pay_active_label span").text('Active');
            }
        })

        stripeData.get().then(  async function(stripeSnapshots){
            var stripe = stripeSnapshots.data();
            if(stripe.isEnabled){
                jQuery(".stripe_active_label span").addClass('badge-success');
                jQuery(".stripe_active_label span").text('Active');
            }
        })


        jQuery("#data-table_processing").hide();
    /* console.log($(".note-editable").html()); */  
        })


                


         $(".save_razorpay_btn").click(function(){
     
        var razorpayKey = $(".razorpay_key").val();
        var razorpaySecret = $(".razorpay_secret").val();
        var isRazorpayenabled = $(".enable_razorpay").is(":checked");
        var sendboxmode = $(".sand_box_mode").is(":checked");

       database.collection('settings').doc("razorpaySettings").update({'isEnabled':isRazorpayenabled,'razorpayKey':razorpayKey,'razorpaySecret':razorpaySecret,'isSandboxEnabled':sendboxmode}).then(function(result) {

                window.location.href = '<?php echo e(url("settings/payment/razorpay")); ?>';
                    
                 });
       
            })


     })
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/settings/app/razorpay.blade.php ENDPATH**/ ?>