<?php $__env->startSection('content'); ?>
	<div class="page-wrapper">
    <div class="row page-titles">

        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.admin_commission')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.admin_commission')); ?></li>
            </ol>
        </div>
    </div>

        <div class="card-body">
      	  <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>
          <div class="row restaurant_payout_create">
            <div class="restaurant_payout_create-inner"> 
              <fieldset>
                <legend><?php echo e(trans('lang.admin_commission')); ?></legend>
                    
                    <div class="form-check width-100">
                      <input type="checkbox" class="form-check-inline" onclick="ShowHideDiv()" id="enable_commission">
                        <label class="col-5 control-label" for="enable_commission"><?php echo e(trans('lang.enable_adminCommission')); ?></label>
                    </div>

                    <div class="form-group row width-50">
                        <label class="col-4 control-label"><?php echo e(trans('lang.commission_type')); ?></label>
                        <div class="col-7">
                          <select class="form-control commission_type" id="commission_type">
                            <option value="Percent"><?php echo e(trans('lang.coupon_percent')); ?></option>
                            <option value="Fixed"><?php echo e(trans('lang.coupon_fixed')); ?></option>
                          </select>
                        </div>
                    </div>

                    <div class="form-group row width-50">
                        <label class="col-4 control-label"><?php echo e(trans('lang.delivery_charge')); ?></label>
                        <div class="col-7">
                          <input type="number" class="form-control delivery_charge">
                        </div>
                    </div>

                    <div class="form-group row width-50" id="how_much_div"style="display:none">
                      <label class="col-4 control-label"><?php echo e(trans('lang.fix_commission')); ?></label>
                      <div class="col-7">
                        <input type="number" class="form-control commission_fix">
                      </div>
                    </div>

              </fieldset>
            </div>
          </div>

          <div class="form-group col-12 text-center">
            <button type="button" class="btn btn-primary save_admin_commission" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
            <a href="<?php echo e(url('/dashboard')); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
          </div>
        </div>    


 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    
    var database = firebase.firestore();
    var ref = database.collection('settings').doc("AdminCommission");
    var ref_deliverycharge = database.collection('settings').doc("DeliveryCharge");

    var photo = "";
    $(document).ready(function(){
        jQuery("#data-table_processing").show();
        ref.get().then( async function(snapshots){
          var adminCommissionSettings = snapshots.data();
          jQuery("#data-table_processing").hide();
            if(adminCommissionSettings.isEnabled){
                $("#enable_commission").prop('checked',true);
                $("#how_much_div").show();
            }
          $(".commission_fix").val(adminCommissionSettings.fix_commission);
          $("#commission_type").val(adminCommissionSettings.commissionType);
        })

        ref_deliverycharge.get().then( async function(snapshots_charge){
            var deliveryChargeSettings = snapshots_charge.data();
            jQuery("#data-table_processing").hide();
            $(".delivery_charge").val(deliveryChargeSettings.amount);
        })




        $(".save_admin_commission").click(function(){
          var checkboxValue = $("#enable_commission").is(":checked");
          var deliveryCharge = parseInt($(".delivery_charge").val());
          var commission_type = $("#commission_type").val();
          var howmuch = parseInt($(".commission_fix").val());
              database.collection('settings').doc("AdminCommission").update({'isEnabled':checkboxValue,'fix_commission':howmuch,'commissionType':commission_type}).then(function(result) {
                        database.collection('settings').doc("DeliveryCharge").update({'amount':deliveryCharge}).then(function(result) {
                            window.location.href = '<?php echo e(url("settings/app/adminCommission")); ?>';
                        });
                });

                    

        })
    })

    function ShowHideDiv(){
      var checkboxValue = $("#enable_commission").is(":checked");
      if(checkboxValue){
      $("#how_much_div").show();
    }else{
      $("#how_much_div").hide();
    }

  }

 
</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/resources/views/settings/app/adminCommission.blade.php ENDPATH**/ ?>