<?php $__env->startSection('content'); ?>

  <div class="page-wrapper">

    <div class="row page-titles">


        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.emergency')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">

            <ol class="breadcrumb">

                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>

                <li class="breadcrumb-item"><a href= "<?php echo route('emergency'); ?>" ><?php echo e(trans('lang.emergency')); ?></a></li>

                <li class="breadcrumb-item active"><?php echo e(trans('lang.emergency_edit')); ?></li>

            </ol>

        </div>

    </div>

    <div class="card-body">

		<div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">
			<?php echo e(trans('lang.processing')); ?>

		</div>

		<div class="error_top"></div>

		<div class="row vendor_payout_create">

			<div class="vendor_payout_create-inner">

				<fieldset>

					<legend>
						<?php echo e(trans('lang.emergency')); ?>

					</legend>

					<div class="form-group row width-50">

						<label class="col-3 control-label"><?php echo e(trans('lang.emergency_name')); ?></label>

						<div class="col-7">

							<input type="text" class="form-control" id="name">

						</div>

					</div>
					
					<div class="form-group row width-50">

						<label class="col-3 control-label"><?php echo e(trans('lang.emergency_number')); ?></label>

						<div class="col-7">

							<input type="text" class="form-control" id="number">

						</div>

					</div>

					<div class="form-group row width-100">

						<div class="form-check width-100">

							<input type="checkbox" id="publish">

							<label class="col-3 control-label" for="publish"><?php echo e(trans('lang.publish')); ?></label>

						</div>

					</div>

				</fieldset>

			</div>
		</div>

	</div>

    <div class="form-group col-12 text-center">

        <button type="button" class="btn btn-primary btn-save"><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>

        <a href="<?php echo route('emergency'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>

    </div>

  </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">

	var database = firebase.firestore();
	
	var id = "<?php echo $id; ?>";
	
	var ref = database.collection('emergency_number').where("id","==",id);
	
	$(document).ready(function(){
	
	    jQuery("#data-table_processing").show();
	
	    ref.get().then( async function(snapshots){
	
	        var result = snapshots.docs[0].data();
	        
	        $("#name").val(result.name);
	        
	        $("#number").val(result.number);
	        
	        if(result.publish){
	             $("#publish").prop( "checked", true );
	        }
	
	        jQuery("#data-table_processing").hide();
	
	    });
	});
	    
	
	
	$(".btn-save").click(function(){
	
	    var name = $("#name").val();
	    var number = $("#number").val();
		var publish =false;
	
	  	if($("#publish").is(':checked')){
	    	publish =true;
	  	}
	
	    if(name == ''){
	
	        $(".error_top").show();
	
	        $(".error_top").html("");
	
	        $(".error_top").append("<p><?php echo e(trans('lang.emergency_name_error')); ?></p>");
	
	        window.scrollTo(0, 0);
	
	    }else if(number == ''){
	        $(".error_top").show();
	
	        $(".error_top").html("");
	
	        $(".error_top").append("<p><?php echo e(trans('lang.emergency_number_error')); ?></p>");
	
	        window.scrollTo(0, 0);
	    }else{
	
	        database.collection('emergency_number').doc(id).update({'id':id,'name':name,'number':number,'publish':publish}).then(function(result){
	            window.location.href = '<?php echo e(route("emergency")); ?>';
	
	        }) .catch(function (error) {
	              $(".error_top").show();
	              $(".error_top").html("");
	              $(".error_top").append("<p>"+error+"</p>");
	
	        });
	    }
	});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/emartadmin.siswebapp.com/resources/views/emergency/edit.blade.php ENDPATH**/ ?>