<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>    
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('images/logo-light-icon.png')); ?>">
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
    <!-- Styles -->
    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/icons/font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/toast-master/css/jquery.toast.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/colors/blue.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body>
    <?php error_reporting(E_ALL ^ E_NOTICE); ?>
    <div id="app" class="fix-header fix-sidebar card-no-border">
            <div id="main-wrapper">

                <header class="topbar">

                <nav class="navbar top-navbar navbar-expand-md navbar-light">
                    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </nav>

                </header>

                <aside class="left-sidebar">

                    <!-- Sidebar scroll-->

                    <div class="scroll-sidebar">

                        <?php echo $__env->make('layouts.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>

                    <!-- End Sidebar scroll-->

                </aside>

            </div>


        

        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    <!-- <script src="<?php echo e(asset('assets/plugins/jquery/jquery.min.js')); ?>"></script> -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.slimscroll.js')); ?>"></script>
    <script src="<?php echo e(asset('js/waves.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sidebarmenu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/sticky-kit-master/dist/sticky-kit.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/sparkline/jquery.sparkline.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script type="text/javascript">
        jQuery(window).scroll(function() {    
            var scroll = jQuery(window).scrollTop();    
            if (scroll <= 60) {
                jQuery("body").removeClass("sticky");
            }else{
                jQuery("body").addClass("sticky");
            }
        });
    </script>
    <script src="https://www.gstatic.com/firebasejs/7.2.0/firebase-app.js"></script>    
    <script src="https://www.gstatic.com/firebasejs/7.2.0/firebase-firestore.js"></script>
    <script src="https://www.gstatic.com/firebasejs/7.2.0/firebase-storage.js"></script>
    <script src="https://www.gstatic.com/firebasejs/7.2.0/firebase-auth.js"></script>
    <script src="https://www.gstatic.com/firebasejs/7.2.0/firebase-database.js"></script>
    <script src="https://unpkg.com/geofirestore/dist/geofirestore.js"></script>
    <script src="https://cdn.firebase.com/libs/geofire/5.0.1/geofire.min.js"></script>
    <script type="text/javascript"><?php echo $__env->make('vendor.notifications.init_firebase', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></script>
    <script type="text/javascript">
        var database = firebase.firestore();
        var geoFirestore = new GeoFirestore(database);
        var createdAtman=firebase.firestore.Timestamp.fromDate(new Date());
        var createdAt={_nanoseconds: createdAtman.nanoseconds,_seconds: createdAtman.seconds};

        var ref = database.collection('settings').doc("globalSettings");
         ref.get().then( async function(snapshots){

            var globalSettings = snapshots.data();            
            $("#app_name").html(globalSettings.applicationName);
            $("#logo_web").attr('src',globalSettings.appLogo);
            //$(".application_description").val(globalSettings.shortDescription);
            ///var photo = globalSettings.appLogo;
            
        });
    </script>
        <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/customer/www/foodie.siswebapp.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>