<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
	<div class="row page-titles">
		<div class="col-md-5 align-self-center">
			<h3 class="text-themecolor"><?php echo e(trans('lang.order_review')); ?></h3>
		</div>

		<div class="col-md-7 align-self-center">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
				<li class="breadcrumb-item"><a href= "<?php echo route('orderReview'); ?>" ><?php echo e(trans('lang.order_review')); ?></a></li>
				<li class="breadcrumb-item active"><?php echo e(trans('lang.food_review_edit')); ?></li>
			</ol>
		</div>
		<div>

			<div class="card-body">
				
				<div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">Processing...</div>

				<div class="row">

					<div class="col-md-6">

              <div class="form-group row">
                <label class="col-4 control-label"><?php echo e(trans('lang.food_review_user_id')); ?></label>
                <select id="reviewer_id" class="form-control col-7"><option value=""><?php echo e(trans('lang.select_user')); ?></option></select>
              </div>

              <div class="form-group row">
                <label class="col-4 control-label"><?php echo e(trans('lang.restaurant')); ?></label>
                <select id="vendor_id" class="form-control col-7"><option value=""><?php echo e(trans('lang.select_food')); ?></option></select>
              </div>

              <div class="form-group row">
                <label class="col-4 control-label"><?php echo e(trans('lang.food_review_rate')); ?></label>
                <div class="col-7">
                  <input type="number" class="form-control user_review_rate" disabled max=5 min=0>
                  <!-- <div class="form-text text-muted">
                    <?php echo e(trans("lang.rating_out_of_five")); ?>

                  </div> -->
                </div>
              </div>

              <div class="form-group row">
                <label class="col-4 control-label"><?php echo e(trans('lang.order_review')); ?></label>
                <div class="col-7">
                  <textarea type="text" rows="7" class="form-control form-control user_review"></textarea>
                </div>
              </div>

          </div>
					
          <div class="col-md-6">

            <div class="form-group row">
              <label class="col-4 control-label"><?php echo e(trans('lang.restaurants_payout_amount')); ?></label>
              <input type="text" class=" col-7 form-control order_price" disabled>
            </div>
            
            <div class="row">

              <div class="col-6">
                <div class="form-group row">
                  <label class="col-12 control-label"><?php echo e(trans('lang.product')); ?></label>
                  <div id="order_products_list"></div>
                </div>
              </div>
              <div class="col-6">
                <div class="form-group row">
                  <label class="col-12 control-label"><?php echo e(trans('lang.quantity')); ?></label>
                  <div id="order_products_quantity"></div>
                </div>
              </div>
          
        </div>

				</div>
			
			</div>

		</div>
		
		  
      <div class="form-group col-12 text-right">
        <button type="button" class="btn btn-primary save_user_review_btn" ><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
        <a href="<?php echo route('orderReview'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
      </div>

	</div>

</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/crypto-js.js"></script>
<script src="<?php echo e(asset('js/bootstrap-datepicker.min.js')); ?>"></script>
<link href="<?php echo e(asset('css/bootstrap-datepicker.min.css')); ?>" rel="stylesheet">
<script>
var id = "<?php echo $id;?>";
var database = firebase.firestore();
var ref = database.collection('foods_review').where("Id","==",id);


$(document).ready(function(){
  jQuery("#data-table_processing").show();
  ref.get().then( async function(snapshots){
  var review = snapshots.docs[0].data();


     
     await database.collection('vendors').get().then( async function(snapshots){
      
       snapshots.docs.forEach((listval) => {
                  var data = listval.data();

                    if(data.id == review.VendorId){
                        $('#vendor_id').append($("<option selected></option>")
                        .attr("value", data.id)
                        .text(data.title));
                    }else{
                          $('#vendor_id').append($("<option></option>")
                        .attr("value", data.id)
                        .text(data.title));
                    }
     

              })

    }); 

     await database.collection('users').where("role","in",["customer","driver"]).get().then( async function(snapshots){
      
       snapshots.docs.forEach((listval) => {
                  var data = listval.data();
                  var userName = data.firstName+" "+data.lastName;
                    if(data.id == review.CustomerId){
                        $('#reviewer_id').append($("<option selected></option>")
                        .attr("value", data.id)
                        .text(userName));
                    }else{
                          $('#reviewer_id').append($("<option></option>")
                        .attr("value", data.id)
                        .text(userName));
                    }
     

              })

    }); 

      var price = 0;
    await database.collection('restaurant_orders').where("id","==",review.orderid).get().then( async function(snapshots){
        console.log(snapshots);
      var order = snapshots.docs[0].data();
        order.products.forEach((product)=>{
        $("#order_products_list").append('<input type="text" class="form-control col-12" value="'+product.name+'" disabled>');
        $("#order_products_quantity").append('<input type="number" class="form-control col-12" value="'+product.quantity+'" disabled>');

        if(product.price && product.quantity != 0){
          var productTotal = parseInt(product.price)*parseInt(product.quantity);
          price = price + productTotal;
        }
      })
    })

  $(".order_price").val(price);
  $(".user_review_rate").val(review.rating);
  $(".user_review").val(review.comment);
  // $(".note-editable").html(review.review);
  jQuery("#data-table_processing").hide();

  })


  
  $(".save_user_review_btn").click(function(){
      //var photo ="https://assets.bonappetit.com/photos/5d03bea59ffc67bff3c6f86e/master/pass/HLY_Lentil_Burger_Horizontal.jpg";
      // var user_review = $(".note-editable").html();
      var user_review = $(".user_review").val();
      var rate = parseFloat($(".user_review_rate").val());
      var user_id = $("#reviewer_id option:selected").val();
      var vendor_id = $("#vendor_id option:selected").val();

      alert("This is for demo, We can't allow to edit");
        /* database.collection('foods_review').doc(id).update({'comment':user_review,'rating':rate,'CustomerId':user_id,'VendorId':vendor_id}).then(function(result) {
                    // scroll(0,0);
                    window.location.href = '<?php echo e(route("orderReview")); ?>';
                 }); */
       
    })


})

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/customer/www/foodie.siswebapp.com/public_html/resources/views/order_reviews/edit.blade.php ENDPATH**/ ?>